
/* VARIABLES USED IN REGRESSIONS CODE:
lpo: LoanValues 
ptpno: Participation
bnpl: Borrower CPRisk
lnpl: Lender CPRisk
bsfln: Borrower Collateral
lsfln: Lender Collateral
bis: LB, i.e. indicator for post-Lehman Brothers default
lbspos: binary variable indicating borrower-lender-market unit had positive loans outstanding in sample
sec (or s): 1(s), i.e. indicator for the repo market
br: factor variable for borrowers
ln: factor variable for lenders
day: factor variable for date
bf: indicator for if borrower is foreign
lf: indicator for if lender is foreign
td: TED spread lagged one day.
UNDERSCORES BETWEEN VARIABLE NAMES REPRESENT INTERACTIONS.
*/

clear all

ssc install reghdfe
ssc install tuples

cd "[FOLDER PATH]"
import delimited using "[DATA FILE]"

set more off

/* Convert variables from string to integer */
encode lnd, generate(ln)
encode brw, generate(br)
rename tedlg td
rename sd day
gen const = day > 0

drop if day > 39724

gen bishock = day > 39705
order bishock, after(td)

// Standardise ted
egen new_day = tag(day)
egen tedmean = mean(td) if new_day == 1
replace tedmean = tedmean[_n-1] if tedmean == .
egen tedsd = sd(td) if new_day == 1
replace tedsd = tedsd[_n-1] if tedsd == .
replace td = (td - tedmean)/ tedsd /* I used to also demean but changed that */

// Remove NAs and replace with missing value, first force variables to string to 
//   make it easier.
foreach v of varlist spr-tedsd {
	tostring `v', force replace
	replace `v' = "." if `v' == "NA" | `v' == "-Inf" | `v' == "Inf"
}
destring, replace
// Scale variables
replace bcgs = bcgs / 1000000000
replace bsgs = bsgs / 1000000000
replace lcgs = lcgs / 1000000000
replace lsgs = lsgs / 1000000000
generate lsf = lcgs + lsgs
generate bsf = bcgs + bsgs

// generate and format the lender sec holdings variables
generate lsfln = ln(lcgs + lsg + 1)
generate lsgln = ln(lsgs + 1)
generate lcgln = ln(lcgs + 1)
generate bsfln = ln(bcgs + bsgs + 1)
generate bsgln = ln(bsgs + 1)
generate bcgln = ln(bcgs + 1)


// Standardise the main variables
egen new_brw = tag(brw)
egen new_lnd = tag(lnd)
foreach v of varlist bnpl bsfln bsgln bcgln {
	egen `v'mn = mean(`v') if new_brw == 1
	replace `v'mn = `v'mn[_n-1] if `v'mn == .
	egen `v'sd = sd(`v') if new_brw == 1
	replace `v'sd = `v'sd[_n-1] if `v'sd == .
	replace `v' = (`v' - `v'mn) / `v'sd
}
// And the lender variables
foreach v of varlist lnpl lsfln lsgln lcgln {
	egen `v'mn = mean(`v') if new_lnd == 1
	replace `v'mn = `v'mn[_n-1] if `v'mn == .
	egen `v'sd = sd(`v') if new_brw == 1
	replace `v'sd = `v'sd[_n-1] if `v'sd == .
	replace `v' = (`v' - `v'mn) / `v'sd
}

order lsfln-lcgln, after(lcgs)
order bsfln-bcgln, after(bcgs)

/* different forms of the DV */
generate po = princ_out / 1000000
generate lpo = ln(po+1)
generate ptpno = (lpo>0)

replace lndomo_gov = ln(lndomo_gov / 1000000)
replace brwomo_gov = ln(brwomo_gov / 1000000)
replace lndomo_prv = ln(lndomo_prv / 1000000)
replace brwomo_prv = ln(brwomo_prv / 1000000)
replace lndomo_tot = ln(lndomo_tot / 1000000)
replace brwomo_tot = ln(brwomo_tot / 1000000)

generate s_td = sec*td
generate s_bis = sec*bishock

foreach v of varlist lsgs-lcgln {
	generate td_`v' = td*`v'
	generate bis_`v' = bishock*`v'
	generate s_`v' = sec*`v'
	generate `v'_lnpl = `v'*lnpl
	generate s_`v'_lnpl = sec*`v'*lnpl
	generate s_td_`v' = sec*td*`v'
	generate td_`v'_lnpl = td*`v'*lnpl
	generate s_td_`v'_lnpl = sec*td*`v'*lnpl
	generate s_bis_`v' = sec*bishock*`v'
	generate bis_`v'_lnpl = bishock*`v'*lnpl
	generate s_bis_`v'_lnpl = sec*bishock*`v'*lnpl
}
generate s_lnpl = sec*lnpl
generate s_td_lnpl = sec*td*lnpl
generate td_lnpl = td*lnpl
generate s_bis_lnpl = sec*bishock*lnpl
generate bis_lnpl = bishock*lnpl


foreach v of varlist bsgs-bcgln {
	generate td_`v' = td*`v'
	generate bis_`v' = bishock*`v'
	generate s_`v' = sec*`v'
	generate `v'_bnpl = `v'*bnpl
	generate s_`v'_bnpl = sec*`v'*bnpl
	generate s_td_`v' = sec*td*`v'
	generate td_`v'_bnpl = td*`v'*bnpl
	generate s_td_`v'_bnpl = sec*td*`v'*bnpl
	generate s_bis_`v' = sec*bishock*`v'
	generate bis_`v'_bnpl =  bishock*`v'*bnpl
	generate s_bis_`v'_bnpl = sec*bishock*`v'*bnpl
}

generate s_bnpl = sec*bnpl
generate s_td_bnpl = sec*td*bnpl
generate td_bnpl = td*bnpl
generate s_bis_bnpl = sec*bishock*bnpl
generate bis_bnpl = bishock*bnpl

/*
[MISSING CODE THAT DEFINES WHICH BANKS ARE FOREIGN AND WHICH ARE DOMESTIC]
*/

// Interact 'secured' with other explanatory variables
foreach d of varlist bf-bas {
	generate s_`d' = sec*`d'
	generate s_td_`d' = sec*td*`d'
	generate td_`d' = td*`d'
	generate s_bis_`d' = sec*bishock*`d'
	generate bis_`d' = bishock*`d'
	foreach v of varlist td_bsgs-bis_bnpl {
		generate `v'_`d' = `v'*`d'
	}
}
foreach d of varlist lf-las {
	generate s_`d' = sec*`d'
	generate s_td_`d' = sec*td*`d'
	generate td_`d' = td*`d'
	generate s_bis_`d' = sec*bishock*`d'
	generate bis_`d' = bishock*`d'
	foreach v of varlist td_lsgs-bis_lnpl {
		generate `v'_`d' = `v'*`d'
	}
}

gen bnpl_lnpl = bnpl*lnpl
gen bsfln_lsfln = bsfln*lsfln
gen bnpl_lsfln = bnpl*lsfln
gen lnpl_bsfln = lnpl*bsfln

// TABLE 2 - BORROWER-LENDER MATCHING
quietly reghdfe lpo bnpl_lnpl bsfln_lsfln bnpl_lsfln lnpl_bsfln if lbspos > 0 & sec == 0, absorb(br ln day) vce(cluster br ln day)
estimates store m1, title("uns quant")
quietly reghdfe ptpno bnpl_lnpl bsfln_lsfln bnpl_lsfln lnpl_bsfln if lbspos > 0 & sec == 0, absorb(br ln day) vce(cluster br ln day)
estimates store m2, title("uns bi")	
quietly reghdfe lpo bnpl_lnpl bsfln_lsfln bnpl_lsfln lnpl_bsfln if lbspos > 0 & sec == 1, absorb(br ln day) vce(cluster br ln day)
estimates store m3, title("sec quant")
quietly reghdfe ptpno bnpl_lnpl bsfln_lsfln bnpl_lsfln lnpl_bsfln if lbspos > 0 & sec == 1, absorb(br ln day) vce(cluster br ln day)
estimates store m4, title("sec bi")
preserve
collapse (sum) po lbspos (max) ptpno (mean) bnpl_lnpl bsfln_lsfln bnpl_lsfln lnpl_bsfln, by(br ln day)
gen lpo = ln(po+1) 
quietly reghdfe lpo bnpl_lnpl bsfln_lsfln bnpl_lsfln lnpl_bsfln if lbspos > 0, absorb(br ln day) vce(cluster br ln day)
estimates store m5, title("bth quant")
quietly reghdfe ptpno bnpl_lnpl bsfln_lsfln bnpl_lsfln lnpl_bsfln if lbspos > 0, absorb(br ln day) vce(cluster br ln day)
estimates store m6, title("bth bi")
restore
esttab m1 m2 m3 m4 m5 m6 /*using timeinvar_matching.tex*/, mtitles ///
cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) ///
varwidth(20) modelwidth(10) r2


* Program for table 3 borrowers' reactions
program define sepmktest	
	quietly reghdfe lpo `1' if lbspos > 0 & sec == 0, absorb(`3') vce(cluster `4')
	estimates store m1, title("uns quant")
	quietly reghdfe lpo `1' `2' if lbspos > 0 & sec == 0, absorb(`3') vce(cluster `4')
	estimates store m2, title("uns quant")
	quietly reghdfe ptpno `1' if lbspos > 0 & sec == 0, absorb(`3') vce(cluster `4')
	estimates store m3, title("uns bi")
	quietly reghdfe ptpno `1' `2' if lbspos > 0 & sec == 0, absorb(`3') vce(cluster `4')
	estimates store m4, title("uns bi")
	quietly reghdfe lpo `1' if lbspos > 0 & sec == 1, absorb(`3') vce(cluster `4')
	estimates store m5, title("sec quant")
	quietly reghdfe lpo `1' `2' if lbspos > 0 & sec == 1, absorb(`3') vce(cluster `4')
	estimates store m6, title("sec quant")
	quietly reghdfe ptpno `1' if lbspos > 0 & sec == 1, absorb(`3') vce(cluster `4')
	estimates store m7, title("sec bi")
	quietly reghdfe ptpno `1' `2' if lbspos > 0 & sec == 1, absorb(`3') vce(cluster `4')
	estimates store m8, title("sec bi")
	preserve
	collapse (sum) po lbspos (max) ptpno (mean) `1' `2', by(br ln day)
	gen lpo = ln(po+1) 
	quietly reghdfe lpo `1' if lbspos > 0, absorb(`3') vce(cluster `4')
	estimates store m9, title("bth quant")
	quietly reghdfe lpo `1' `2' if lbspos > 0, absorb(`3') vce(cluster `4')
	estimates store m10, title("bth quant")
	quietly reghdfe ptpno `1' if lbspos > 0, absorb(`3') vce(cluster `4')
	estimates store m11, title("bth bi")
	quietly reghdfe ptpno `1' `2' if lbspos > 0, absorb(`3') vce(cluster `4')
	estimates store m12, title("bth bi")
	restore
	esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11 m12 `5', mtitles ///
	cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) ///
	varwidth(20) modelwidth(10) r2	
end

// TABLE 3 - BORROWERS' REACTIONS
sepmktest "bis_bnpl bis_bsfln" "bis_bsfln_bnpl" "br ln#day" "br ln day" ""


// TABLE  4 - BORROWERS' SUBSTITUTION
quietly reghdfe lpo sec s_bis s_bnpl s_bis_bnpl s_bsfln s_bis_bsfln if sec >= 0, ///
absorb(br#ln#day) vce(cluster br ln day)
estimates store m1, title("value")
quietly reghdfe lpo sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl if sec >= 0, ///
absorb(br#ln#day) vce(cluster br ln day)
estimates store m2, title("value")
quietly reghdfe ptpno sec s_bsfln s_bnpl s_bis s_bis_bsfln s_bis_bnpl if sec >= 0, ///
absorb(br#ln#day) vce(cluster br ln day)
estimates store m3, title("ptpn")
quietly reghdfe ptpno sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl if sec >= 0, ///
absorb(br#ln#day) vce(cluster br ln day)
estimates store m4, title("ptpn")
esttab m1 m2 m3 m4 /*using mktdiftables.tex*/, mtitles ///
cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) varwidth(30) modelwidth(10) ///
r2 drop(sec s_bis s_bnpl s_bsfln s_bsfln_bnpl)


* Program for Table 5 varying levels of fixed effects
program define estaddstuff2	
	estadd local cntrls "yes"
	estadd local bx `1'
	estadd local dx `2'
	estadd local lx `3'
	estadd local sx `4'
	estadd local bdx `5'
	estadd local ldx `6'
	estadd local blx `7'
	estadd local bldx `8'
	estadd local blsx `9'
	estadd local lsdx `10'
end
* Program for Table 5 varying levels of fixed effects
program define bigFEtable2
	quietly reghdfe `1' const bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(const) vce(cluster `2')
	estimates store m1, title("ptpn")
	quietly estaddstuff2 "no" "no" "no" "no" "no" "no" "no" "no" "no" "no"
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br) vce(cluster `2')
	estimates store m2, title("ptpn")
	quietly estaddstuff2 "yes" "no" "no" "no" "no" "no" "no" "no" "no" "no"
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br day) vce(cluster `2')
	estimates store m3, title("ptpn")
	quietly estaddstuff2 "yes" "yes" "no" "no" "no" "no" "no" "no" "no" "no"
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br ln day) vce(cluster `2')
	estimates store m4, title("ptpn")
	quietly estaddstuff2 "yes" "yes" "yes" "no" "no" "no" "no" "no" "no" "no" 
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br#day) vce(cluster `2')
	estimates store m5, title("ptpn")
	quietly estaddstuff2 "." "." "no" "no" "yes" "no" "no" "no" "no" "no"
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(ln#day) vce(cluster `2')
	estimates store m6, title("ptpn")
	quietly estaddstuff2 "no" "." "." "no" "no" "yes" "no" "no" "no" "no"	
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br#ln) vce(cluster `2')
	estimates store m7, title("ptpn")
	quietly estaddstuff2 "." "no" "." "no" "no" "no" "yes" "no" "no" "no"		
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br#day ln) vce(cluster `2')
	estimates store m8, title("ptpn")
	quietly estaddstuff2 "." "." "yes" "no" "yes" "no" "no" "no" "no" "no" 	
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br#day ln#day) vce(cluster `2')
	estimates store m9, title("ptpn")
	quietly estaddstuff2 "." "." "." "no" "yes" "yes" "no" "no" "no" "no" 	
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br#ln#day) vce(cluster `2')
	estimates store m10, title("ptpn")
	quietly estaddstuff2 "." "." "." "no" "." "." "." "yes" "no" "no" 	
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br#ln#day sec) vce(cluster `2')
	estimates store m11, title("ptpn")
	quietly estaddstuff2 "." "." "." "yes" "" "." "." "yes" "no" "no" 	
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br#ln#day br#ln#sec) vce(cluster `2')
	estimates store m12, title("ptpn")
	quietly estaddstuff2 "." "." "." "." "." "." "." "yes" "yes" "no"	
	quietly reghdfe `1' bsfln bnpl bsfln_bnpl bishock bis_bsfln bis_bnpl bis_bsfln_bnpl ///
	sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl, ///
	absorb(br#ln#day br#ln#sec ln#sec#day) vce(cluster `2')
	estimates store m13, title("ptpn")
	quietly estaddstuff2 "." "." "." "." "." "." "." "yes" "yes" "yes" 
end

// TABLE 5 - VARYING LEVELS OF FIXED EFFECTS
bigFEtable2 "lpo" "br ln day"
esttab m* /*using bigFE2.tex*/,  scalars("cntrls lower interactions" "bx brw FE" "dx day FE" "lx lnd FE" ///
"sx sec FE" "bdx brw x day FE" "ldx lnd x day FE" "blx brw x lnd FE" "bldx brw x lnd x day FE" ///
"blsx sec x brw x lnd FE" "lsdx sec x lnd x day FE") keep(s_bis_bsfln_bnpl) ///
cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) modelwidth(9) ///
label r2 title("Participation regressions with brw and lnd and day clustering")
bigFEtable2 "ptpno" "br ln day"
esttab m*,  scalars("cntrls lower interactions" "bx brw FE" "dx day FE" "lx lnd FE" ///
"sx sec FE" "bdx brw x day FE" "ldx lnd x day FE" "blx brw x lnd FE" "bldx brw x lnd x day FE" ///
"blsx sec x brw x lnd FE" "lsdx sec x lnd x day FE") keep(s_bis_bsfln_bnpl) ///
cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) modelwidth(9) ///
label r2 title("Participation regressions with brw and lnd*day clustering")
* Additional regresions for R squared stat in footnote 13 
reghdfe lpo sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl if sec >= 0, absorb(br#ln ln#day br#day) vce(cluster br ln day)
reghdfe ptpno sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl if sec >= 0, absorb(br#ln ln#day br#day) vce(cluster br ln day)


// TABLE 5 - LENDERS' REACTIONS - INTERBANK MARKET
sepmktest "bis_lnpl bis_lsfln" "bis_lsfln_lnpl" "ln br#day" "br ln day" ""
// TABLE 5 - LENDERS' REACTIONS - OMO BORROWING
preserve
	collapse (mean) lndomo_gov lndomo_prv po bishock lnpl lsfln lsfln_lnpl bis_lnpl bis_lsfln bis_lsfln_lnpl, by(ln day)
	quietly reghdfe lndomo_gov bis_lnpl bis_lsfln, absorb(ln day) vce(cluster ln day)
	estimates store m1
	quietly reghdfe lndomo_gov bis_lnpl bis_lsfln bis_lsfln_lnpl, absorb(ln day) vce(cluster ln day)
	estimates store m2
	quietly reghdfe lndomo_prv bis_lnpl bis_lsfln, absorb(ln day) vce(cluster ln day)
	estimates store m3
	quietly reghdfe lndomo_prv bis_lnpl bis_lsfln bis_lsfln_lnpl, absorb(ln day) vce(cluster ln day)
	estimates store m4	
	esttab m1 m2 m3 m4 /*using mkbisiftables.tex*/, mtitles ///
	cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) varwidth(30) modelwidth(10) r2 	
restore


* Program for rubstness regressions
program define robustest 
	quietly reghdfe lpo `1' if lbspos > 0 & sec == 0, absorb(br ln#day) vce(`5')
	estimates store m1
	quietly reghdfe ptpno `1' if lbspos > 0 & sec == 0, absorb(br ln#day) vce(`5')
	estimates store m2
	quietly reghdfe lpo `1' if lbspos > 0 & sec == 1, absorb(br ln#day) vce(`5')
	estimates store m3
	quietly reghdfe ptpno `1' if lbspos > 0 & sec == 1, absorb(br ln#day) vce(`5')
	estimates store m4
	
	quietly reghdfe lpo `4' if lbspos > 0 & sec == 0, absorb(ln br#day) vce(`5')
	estimates store m5
	quietly reghdfe ptpno `4' if lbspos > 0 & sec == 0, absorb(ln br#day) vce(`5')
	estimates store m6
	quietly reghdfe lpo `4' if lbspos > 0 & sec == 1, absorb(ln br#day) vce(`5')
	estimates store m7
	quietly reghdfe ptpno `4' if lbspos > 0 & sec == 1, absorb(ln br#day) vce(`5')
	estimates store m8
	
	quietly reghdfe lpo sec `2' `3' if sec >= 0, absorb(br#ln#day) vce(`6')
	estimates store m9
	quietly reghdfe ptpno sec `2' `3' if sec >= 0, absorb(br#ln#day) vce(`6')
	estimates store m10
	
	esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10, ///
	cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) ///
	varwidth(20) modelwidth(10) r2 drop(sec `2')
end

// TABLE B4 - ROBUSTNESS TO DOMICILE 
robustest "bis_bf bis_bsfln bis_bsfln_bf" ///
"s_bsfln s_bf s_bsfln_bf s_bis" "s_bis_bf s_bis_bsfln s_bis_bsfln_bf" ///
"bis_lf bis_lsfln bis_lsfln_lf" "cluster br ln day" "cluster br ln day"
	
// TABLE B5 - ROBUSTNESS TO SHOCK MEASURE 
robustest "td_bnpl td_bsfln td_bsfln_bnpl" ///
"s_bsfln s_bnpl s_bsfln_bnpl s_td" "s_td_bnpl s_td_bsfln s_td_bsfln_bnpl" ///
"td_lnpl td_lsfln td_lsfln_lnpl" "cluster br ln day" "cluster br ln day"
	
// TABLE B6 - ROBUSTNESS TO STANDARD ERROR METHOD
robustest "bis_bnpl bis_bsfln bis_bsfln_bnpl" ///
"s_bsfln s_bnpl s_bsfln_bnpl s_bis" "s_bis_bnpl s_bis_bsfln s_bis_bsfln_bnpl" ///
"bis_lnpl bis_lsfln bis_lsfln_lnpl" "cluster br#day ln#day br#ln" "cluster br ln"
	
